package com.agilex.healthcare.veteranappointment.serializer;

import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import org.springframework.stereotype.Component;

import java.io.IOException;

@Component
public class JsonDOBDateSerializer extends JsonSerializer<DOBDate> {
    
    @Override
    public void serialize(DOBDate date, JsonGenerator gen, SerializerProvider provider) throws IOException, JsonProcessingException {

        String formattedDate = date.toString();
        gen.writeString(formattedDate);
    }
}
